#version 330
#extension GL_EXT_gpu_shader4 : enable
// Another Collatz FractalMod01.fsh  by Ebanflo 

//https://www.shadertoy.com/view/ldycWR
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

//The Collatz sequence diverges for most of the complex plane
//So how about look at the direction that it diverges in?
//That's how this fractal is constructed

#define derivative
//#define ratio

#define interactive
#define sensitivity 2.0
//#define grid
#define gridThickness 0.001

#define scale 1.0//exp(-5.5 - 5.5*sin(0.1*iTime))
#define yShift 0.0
#define xShift 0.0

#define AA 2
#define fractalIters 55
const float pi = 3.14159;

vec2 cexp(vec2 z){return exp(z.x)*vec2(cos(z.y), sin(z.y));}
vec2 cexpj(vec2 z){return exp(-z.y)*vec2(cos(z.x), sin(z.x));}
vec2 cmul(vec2 a, vec2 b){return vec2( a.x*b.x - a.y*b.y, a.x*b.y + a.y*b.x );}

vec2 m(float t){
    return iMouse.xy == vec2(0) ? -0.25*vec2(cos(t), 1.0 - sin(t))
    : sensitivity*(2.0*iMouse.xy - iResolution.xy)/iResolution.y;
}

vec2 collatz(vec2 z){
    #ifdef interactive
    return 1.75*z + 2.0*m(iTime) - cmul(cexpj(pi*z), 1.25*z + vec2(0.5, 0));
    #else
    return 1.75*z + vec2(0.5, 0) - cmul(cexpj(pi*z), 1.25*z + vec2(0.5, 0));    
    #endif
}

vec2 dCollatz(vec2 z){
    return vec2(1.75, 0) - cmul(1.25*pi*vec2(-z.y, z.x) + vec2(1.25, 0) + vec2(0.5*pi, 0), cexpj(pi*z));
}

vec3 hsv2rgb(vec3 c) {
  vec4 K = vec4(1.0, 2.0 / 3.0, 1.0 / 3.0, 3.0);
  vec3 p = abs(fract(c.xxx + K.xyz) * 6.0 - K.www);
  return c.z * mix(K.xxx, clamp(p - K.xxx, 0.0, 1.0), c.y);
}

vec3 render(vec2 xy){
    #ifdef grid
    vec2 f = fract(xy);
    if(f.x < gridThickness || f.y < gridThickness) return vec3(0);
    #endif
    vec2 z = xy;
    vec2 dz = vec2(1, 0);
    for(int i = 0; i < fractalIters; i++){
        dz = cmul(dz, dCollatz(z));
        z = collatz(z);
    }
    #ifdef ratio
    return vec3(length(z)/length(dz));
    #endif
    #ifdef derivative
    float arg = atan(dz.y, dz.x);
    #else
    float arg = atan(z.y, z.x);
    #endif
    //return vec3(z == z);
    //return vec3(abs(arg - 0.25*pi));
    return hsv2rgb(0.5 + 0.5*sin(arg - vec3(0, 0.666666*pi, 1.333333*pi))).bgr;
}    

vec2 rect(vec2 frag){
    return scale*(2.0*frag - iResolution.xy)/iResolution.y + vec2(xShift, yShift);
}
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    vec3 col = vec3(0);
    
#if AA>1
    for( int m=0; m<AA; m++ )
    for( int n=0; n<AA; n++ )
    {
        vec2 px = rect(gl_FragCoord.xy + vec2(m, n)/float(AA));
    	col += render(px);    
    }
    col /= float(AA*AA);
#else
        
    col = render(rect(gl_FragCoord.xy));
#endif            
    
	gl_FragColor = vec4(col, 1.0);
}